#import <Foundation/Foundation.h>
#import "MCSQLiteDefines.h"

#import "sqlite3.h"

@class MCSQLiteContext;

#if (defined(MAC_OS_X_VERSION_10_5) && (MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_5))
@interface MCSQLiteResultSet : NSObject <NSFastEnumeration> {
#else 
@interface MCSQLiteResultSet : NSObject {
#endif
	BOOL reusable;
	BOOL stripNSNulls;
	
	NSDictionary*  columnNameHints;
	NSDictionary*  columnTypeHints;
	
	NSString *sql;
	NSArray *argumentNames;

	sqlite3_stmt *stmt;
	MCSQLiteContext *context;
}

+ (id)resultSetWithFormat:(NSString *)sql argumentEnumerator:(NSEnumerator *)anEnumerator context:(MCSQLiteContext *)aContext;
- (id)initWithFormat:(NSString *)sql argumentEnumerator:(NSEnumerator *)anEnumerator context:(MCSQLiteContext *)aContext;

    
+ (void)setDateClass: (Class)aClass;

#pragma mark -
#pragma mark Accessors
- (BOOL)reusable;
- (void)setReusable:(BOOL)flag;

- (BOOL)stripNSNulls;
- (void)setStripNSNulls:(BOOL)flag;
	
- (NSDictionary *)columnNameHints;
- (void)setColumnNameHints:(NSDictionary *)aColumnNameHints;

- (NSDictionary*)columnTypeHints;
- (void)setColumnTypeHints: (NSDictionary*)aColumnTypeHints;
	
- (NSString *)sql;
- (void)setSql:(NSString *)aSql;

- (NSArray *)argumentNames;
- (void)setArgumentNames:(NSArray *)anArray;

- (sqlite3_stmt *)stmt;
- (void)setStmt:(sqlite3_stmt *)aStmt;

- (MCSQLiteContext *)context;
- (void)setContext:(MCSQLiteContext *)aContext;

#pragma mark -
#pragma mark Operations
- (BOOL)bindObject:(id)anObject toArgumentAtIndex:(int)anIndex;
- (BOOL)bindObject:(id)anObject toArgumentNamed:(NSString *)aKey;

- (id)nextObject;
- (id)nextObject:(int *)anErrorCodeP;

- (id)onlyObject;
- (NSArray *)allObjects;

- (BOOL)rewind;
- (void)close;

@end
